/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.items;

import com.ldtteam.structures.helpers.Settings;
import com.ldtteam.structurize.placement.handlers.placement.PlacementError;
import com.ldtteam.structurize.util.LanguageHandler;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.permissions.Action;
import com.minecolonies.api.creativetab.ModCreativeTabs;
import com.minecolonies.api.util.WorldUtil;
import com.minecolonies.coremod.MineColonies;
import com.minecolonies.coremod.items.AbstractItemMinecolonies;
import java.util.List;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ItemSupplyCampDeployer
extends AbstractItemMinecolonies {
    private static final String SUPPLY_CAMP_STRUCTURE_NAME = "supplycamp";
    private static final int OFFSET_DISTANCE = 5;
    private static final int OFFSET_LEFT = 0;
    private static final int OFFSET_Y = 0;

    public ItemSupplyCampDeployer(Item.Properties properties) {
        super("supplycampdeployer", properties.func_200917_a(1).func_200916_a(ModCreativeTabs.MINECOLONIES));
    }

    @NotNull
    public ActionResultType func_195939_a(ItemUseContext ctx) {
        if (ctx.func_195991_k().field_72995_K) {
            if (!((Boolean)MineColonies.getConfig().getServer().allowOtherDimColonies.get()).booleanValue() && !WorldUtil.isOverworldType(ctx.func_195991_k())) {
                LanguageHandler.sendPlayerMessage((PlayerEntity)ctx.func_195999_j(), (String)"com.minecolonies.coremod.dimension.no", (Object[])new Object[0]);
                return ActionResultType.FAIL;
            }
            this.placeSupplyCamp(ctx.func_195995_a(), ctx.func_195999_j().func_174811_aO());
        }
        return ActionResultType.FAIL;
    }

    @NotNull
    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, Hand hand) {
        ItemStack stack = playerIn.func_184586_b(hand);
        if (worldIn.field_72995_K) {
            if (!((Boolean)MineColonies.getConfig().getServer().allowOtherDimColonies.get()).booleanValue() && !WorldUtil.isOverworldType(worldIn)) {
                LanguageHandler.sendPlayerMessage((PlayerEntity)playerIn, (String)"com.minecolonies.coremod.dimension.no", (Object[])new Object[0]);
                return new ActionResult(ActionResultType.FAIL, (Object)stack);
            }
            this.placeSupplyCamp(null, playerIn.func_174811_aO());
        }
        return new ActionResult(ActionResultType.FAIL, (Object)stack);
    }

    private void placeSupplyCamp(@Nullable BlockPos pos, @NotNull Direction direction) {
        int rotations;
        BlockPos tempPos;
        if (pos == null) {
            MineColonies.proxy.openBuildToolWindow(null, SUPPLY_CAMP_STRUCTURE_NAME, 0);
            return;
        }
        switch (direction) {
            case SOUTH: {
                tempPos = pos.func_177982_a(0, 0, 5);
                rotations = 3;
                break;
            }
            case NORTH: {
                tempPos = pos.func_177982_a(0, 0, -5);
                rotations = 1;
                break;
            }
            case EAST: {
                tempPos = pos.func_177982_a(5, 0, 0);
                rotations = 2;
                break;
            }
            default: {
                tempPos = pos.func_177982_a(-5, 0, 0);
                rotations = 0;
            }
        }
        MineColonies.proxy.openBuildToolWindow(tempPos, SUPPLY_CAMP_STRUCTURE_NAME, rotations);
    }

    public static boolean canCampBePlaced(@NotNull World world, @NotNull BlockPos pos, @NotNull List<PlacementError> placementErrorList, PlayerEntity placer) {
        BlockPos zeroPos = pos.func_177973_b((Vector3i)Settings.instance.getActiveStructure().getPrimaryBlockOffset());
        short sizeX = Settings.instance.getActiveStructure().getSizeX();
        short sizeZ = Settings.instance.getActiveStructure().getSizeZ();
        for (int z = zeroPos.func_177952_p(); z < zeroPos.func_177952_p() + sizeZ; ++z) {
            for (int x = zeroPos.func_177958_n(); x < zeroPos.func_177958_n() + sizeX; ++x) {
                ItemSupplyCampDeployer.checkIfSolidAndNotInColony(world, new BlockPos(x, zeroPos.func_177956_o(), z), placementErrorList, placer);
                if (!world.func_180495_p(new BlockPos(x, zeroPos.func_177956_o() + 1, z)).func_185904_a().func_76220_a()) continue;
                PlacementError placementError = new PlacementError(PlacementError.PlacementErrorType.NEEDS_AIR_ABOVE, new BlockPos(x, pos.func_177956_o(), z));
                placementErrorList.add(placementError);
            }
        }
        return placementErrorList.isEmpty();
    }

    private static void checkIfSolidAndNotInColony(World world, BlockPos pos, @NotNull List<PlacementError> placementErrorList, PlayerEntity placer) {
        PlacementError placementError;
        boolean isSolid = world.func_180495_p(pos).func_185904_a().func_76220_a();
        boolean notInAnyColony = ItemSupplyCampDeployer.hasPlacePermission(world, pos, placer);
        if (!isSolid) {
            placementError = new PlacementError(PlacementError.PlacementErrorType.NOT_SOLID, pos);
            placementErrorList.add(placementError);
        }
        if (!notInAnyColony) {
            placementError = new PlacementError(PlacementError.PlacementErrorType.INSIDE_COLONY, pos);
            placementErrorList.add(placementError);
        }
    }

    private static boolean hasPlacePermission(World world, BlockPos pos, PlayerEntity placer) {
        IColony colony = IColonyManager.getInstance().getColonyByPosFromWorld(world, pos);
        return colony == null || colony.getPermissions().hasPermission(placer, Action.PLACE_BLOCKS);
    }
}

